﻿//////////////////////////////////////////////
// ComplexEffectManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkAstraeus
{
	class ComplexEffect ;
	class System ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../Dll/DllDefines.h"

#include "ComplexEffectType.h"

// nkCommon
#include <nilkinsCommon/Patterns/MaybeSingletonClass.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <string>
#include <unordered_map>

/// Class ------------------------------------

namespace nkAstraeus
{
	class DLL_ASTRAEUS_EXPORT ComplexEffectManager final : public nkCommon::MaybeSingletonClass<ComplexEffectManager>
	{
		public :

			// Management
			ComplexEffect* createOrRetrieve (nkMemory::StringView name, COMPLEX_EFFECT_TYPE type) ;
			ComplexEffect* record (nkMemory::StringView name, nkMemory::UniquePtr<ComplexEffect> resource) ;
			ComplexEffect* get (nkMemory::StringView name) ;
			ComplexEffect* getByIndex (unsigned int id) ;
			void rename (nkMemory::StringView currentName, nkMemory::StringView newName) ;
			void erase (nkMemory::StringView name) ;
			nkMemory::UniquePtr<ComplexEffect> relinquish (nkMemory::StringView name) ;

		private :

			// Functions
			// Constructor, destructor
			ComplexEffectManager (bool isSingleton) noexcept ;
			ComplexEffectManager (System* system) noexcept ;
			ComplexEffectManager (const ComplexEffectManager&) = delete ;
			ComplexEffectManager (ComplexEffectManager&&) = delete ;
			~ComplexEffectManager () ;

			// Operators
			ComplexEffectManager& operator= (const ComplexEffectManager&) = delete ;
			ComplexEffectManager& operator= (ComplexEffectManager&&) = delete ;

		private :

			// Attributes
			System* _system ;

			// Memory
			std::unordered_map<std::string, nkMemory::UniquePtr<ComplexEffect>> _memory ;

		private :

			friend class nkCommon::MaybeSingletonClass<ComplexEffectManager> ;
			friend class System ;
	} ;
}